cordova.define("cordova-plugin-utilities.Utilities", function(require, exports, module) {
/* global cordova */
var argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');

var Utilities = function() {}

Utilities.prototype.getTelemetryInfo = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.getTelemetryInfo",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"getInfo",
		[]
	);
}

Utilities.prototype.requestPermission = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.requestPermission",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"requestPermission",
		[]
	);
}

Utilities.prototype.getFreeDiskSpace = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.getFreeDiskSpace",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"getFreeDiskSpace",
		[]
	);
}

Utilities.prototype.getAppVersion = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.getAppVersion",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"getAppVersion",
		[]
	);
}

Utilities.prototype.getPNToken = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.getPNToken",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"getPNToken",
		[]
	);
}

Utilities.prototype.getDeepLink = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.getDeepLink",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"getDeepLink",
		[]
	);
}

Utilities.prototype.showStatusBar = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.showStatusBar",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"showStatusBar",
		[]
	);
}

Utilities.prototype.setStatusBarStyle = function (
	style,
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"NFF",
		"Utilities.setStatusBarStyle",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"setStatusBarStyle",
		[style]
	);
}

Utilities.prototype.showStoreAppPage = function (
	storeId,
	showRatingsPage,
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"S*FF",
		"Utilities.showStoreAppPage",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"showStoreAppPage",
		[storeId, !!showRatingsPage ? "true" : "false"]
	);
}

Utilities.prototype.showAppSettings = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"Utilities.showAppSettings",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"Utilities",
		"showAppSettings",
		[]
	);
}

module.exports = Utilities;
});
